gMaxSize = GetConfigNumber(GetScriptConfig(),"max_size_kb",1024) * 1024
gMaxCount = GetConfigNumber(GetScriptConfig(),"max_count",10)
gResolution = {1280,720}
gCompression = -1

local resolution = GetConfigString(GetScriptConfig(),"png_resolution")
if resolution then
	local found,_,width,height = string.find(resolution,"(%d+)%s*[xX,]%s*(%d+)")
	if found then
		gResolution = {math.floor(tonumber(width)),math.floor(tonumber(height))}
	else
		PrintWarning("invalid png_resolution configured")
	end
end

local compression = GetConfigNumber(GetScriptConfig(),"png_compression")
if compression then
	compression = math.floor(compression)
	if compression >= 0 and compression <= 9 then
		gCompression = compression
	else
		PrintWarning("invalid png_compression configured")
	end
end
